global PxApexModsToDelete = #()			-- needs to delete the modifiers in the array after adding the new physics modifier.
global PxApexModsToDeleteForce = #()	-- always force to delete modifiers in the array

-- Is this a graphical mesh modifier?
fn PxIsApexGraphicalMod modApexClothing =
(
	if	modApexClothing.name == nvpxText.TXT_MODIFIERCLOTHING_CLOTHING_CLASS_NAME or 
		modApexClothing.name == nvpxText.TXT_MODIFIERCLOTHING_SBCLOTHING_CLASS_NAME then true
	else false
)

-- Find the clothing modifier on the given node
fn PxFindApexGraphicalMod node =
(
	if node == undefined then undefined
	else
	(
		modClothing	  = node.modifiers[nvpxText.TXT_MODIFIERCLOTHING_CLOTHING_CLASS_NAME]
		modSBClothing = node.modifiers[nvpxText.TXT_MODIFIERCLOTHING_SBCLOTHING_CLASS_NAME]
		if isgrouphead(node) then
		( 
			modClothing = node.children[1].modifiers[nvpxText.TXT_MODIFIERCLOTHING_CLOTHING_CLASS_NAME]
			modSBClothing = node.children[1].modifiers[nvpxText.TXT_MODIFIERCLOTHING_SBCLOTHING_CLASS_NAME]
		)
		
		if modClothing != undefined and modSBClothing != undefined then 
			print "APEX Clothing and APEX Softbody should not be applied to the same node!"
			
		if modClothing == undefined then modSBClothing
		else modClothing
	)
)

-- Find the clothing LOD modifier on the given node
fn PxFindApexLODMod node =
(
	if node == undefined then
	(
		undefined
	)
	else
	(	
		modClothing = node.modifiers[nvpxText.TXT_MODIFIERCLOTHING_LOD_CLASS_NAME]
		
		if isgrouphead(node) then modeClothing = node.children[1].modifiers[nvpxText.TXT_MODIFIERCLOTHING_LOD_CLASS_NAME]
		
		modClothing
	)
)

-- Store modifiers in a list to be later deleted
fn PxAddModifierToTrash node mod =
(
	mods = node.modifiers
	PxApexModsToDelete = #()
	if PxIsApexGraphicalMod(mod) then 
		append PxApexModsToDelete mod
)

-- Remove any modifiers that match the spec in our trash list
fn PxEmptyModifierTrash node mod =
(
	--format "PxEmptyModifierTrash\n"
	for i in PxApexModsToDelete do
	(
		if i == mod then
		(
			--format "Remove: %\n" i
			deleteModifier node i
		)
	)
	
	for j in PxApexModsToDeleteForce do
	(
		deleteModifier node j
	)
	PxApexModsToDeleteForce = #()
)

-- Turn a node into a graphical modifier node.  Called when you choose the menu option, instead
-- of directly adding the modifier.
fn PxAddApexClothingMod n =
(
	if isgroupmember(n) then undefined
	else
	(
		modClothing = PxFindApexGraphicalMod n
		
		modClothingLOD = PxFindApexLODMod n
		--format "PxAddApexClothingMod: %, %\n" modClothing modClothingLOD
		if modClothing == undefined and modClothingLOD == undefined then 
		(
			modClothing = APEXClothing()

			if isgrouphead(n) then
			(
				children = #()
				pxSelectionTool.GetAllGroupChildren n children
				for i in children do addmodifier i modClothing
			)
			else
			(
				--format "add mod to node: %\n" n
				addmodifier n modClothing
			)
		)
	)
)

-- add apex softbody clothing modifier via script
fn PxAddApexSBClothingMod n =
(
	if isgroupmember(n) then undefined
	else
	(
		modClothing = PxFindApexGraphicalMod n
		modClothingLOD = PxFindApexLODMod n
		
		if modClothing == undefined and modClothingLOD == undefined then 
		(
			modClothing = APEXSBClothing()

			if isgrouphead(n) then
			(
				children = #()
				pxSelectionTool.GetAllGroupChildren n children
				for i in children do addmodifier i modClothing
			)
			else
			(
				addmodifier n modClothing
			)
		)
	)
)

-- Given a list of nodes, add apex clothing to them
fn PxAddApexClothingToNodes nodes =
(
	for i in nodes do PxAddApexClothingMod i
)

fn PxAddApexSBClothingToNodes nodes =
(
	for i in nodes do PxAddApexSBClothingMod i
)

-- If adding an apex modifier, prepare to remove the previous one so there is only one on the stack
fn PxApexModifierPreAdded =
(

	t = callbacks.notificationParam()
	node = t[1]
	modApexClothing  = t[2]
	
	if (node != undefined) then
	(
		if PxIsApexGraphicalMod(modApexClothing) then 
		(
			-- Don't add it if there is no skin
			if (node.modifiers[#Skin] == undefined) then
			(
				messagebox nvpxText.TXT_MODIFIERCLOTHING_FAIL_TO_ADD
				PxApexModsToDeleteForce = #()
				PxApexModsToDelete = #()
				append PxApexModsToDeleteForce modApexClothing
			)
			else
			(
				PxStopSimulation()
				-- cancel this addition
				existingClothingMod = PxFindApexGraphicalMod node
				--format "PxApexModifierPreAdded %\n" existingClothingMod
				
				if (existingClothingMod != undefined) then
					PxAddModifierToTrash node modApexClothing
			)
		)	
	)
)

-- Delete a modifer that was prepared to be deleted, and setup the physical mesh
fn PxApexModifierPostAdded =
(
	t = callbacks.notificationParam()
	node = t[1]
	
	if node != undefined then
	(
		modApexClothing  = t[2]
		
		-- If we added a graphical modifier...
		if PxIsApexGraphicalMod(modApexClothing) then 
		(
			-- Remove new clothing modifier on this node
			PxEmptyModifierTrash node modApexClothing
		)
	)	
)

-- If the modifier is being deleted, stop the simulation
fn PxApexModifierPreDelete =
(
	t = callbacks.notificationParam()
	node = t[1]
	mod  = t[2]
	
	if PxIsApexGraphicalMod(mod) then
	(
		PxStopSimulation()
	)
)

-- Intialize the callbacks
callbacks.removeScripts id:#ApexClothingModifier
callbacks.addScript #preModifierAdded    "PxApexModifierPreAdded()"       id:#ApexClothingModifier
callbacks.addScript #postModifierAdded   "PxApexModifierPostAdded()"      id:#ApexClothingModifier
callbacks.addScript #preModifierDeleted  "PxApexModifierPreDelete()"      id:#ApexClothingModifier


-- Export

fn APEXSaveFBX filename scale =
(
	format nvpxText.TXT_MODIFIERCLOTHING_INFO_SAVING_FMT filename
	
	pluginManager.loadClass FBXEXP 
		
	FBXExporterSetParam "Animation" true 
	FBXExporterSetParam "ForceNormalsByControlPoint" false 
	FBXExporterSetParam "GeomAsBone" true 
	FBXExporterSetParam "BakeAnimation" true -- set to bake animation to ensure exporting to Clothing Tool works
	FbxExporterSetParam "NormalsPerPoly" false
	FBXExporterSetParam "Skin" true
	FBXExporterSetParam "Shape" true
	FBXExporterSetParam "PointCache" false 
	FBXExporterSetParam "Removesinglekeys" true
	FBXExporterSetParam "Export|IncludeGrp|Animation|CurveFilter" true
	FBXExporterSetParam "Export|IncludeGrp|Animation|CurveFilter|CurveFilterApplyUnroll" true
	FBXExporterSetParam "FilterKeyReducer" false 
	FBXExporterSetParam "Cameras" false 
	FBXExporterSetParam "Lights" false 
	FBXExporterSetParam "EmbedTextures" false 
	--REM:DH we should not be converting units.--FBXExporterSetParam "ConvertUnit" "in" 
	FBXExporterSetParam "UpAxis" "Z" 
	FBXExporterSetParam "ShowWarnings" false
	FBXExporterSetParam "FileVersion" "FBX201000" 
	FBXExporterSetParam "ScaleFactor" scale
	ExportFile filename #noPrompt selectedOnly:false using:FBXEXP

	undefined
)


